$(window).on("load", function () {
	
	// global functions =============================================================
	var IUPACcharacters = [ 'a', 'c', 'g', 't', 'r', 'y', 's', 'w', 'k', 'm', 'b', 'd', 'h', 'v', 'n', '*',
							'A', 'C', 'G', 'T', 'R', 'Y', 'S', 'W', 'K', 'M', 'B', 'D', 'H', 'V', 'N' ];
	var operations = [8, 9, 37, 39, 46];   // TAB, left arrow, right arrow, delete, backspace
	var numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
	var brakers = ['[', ']'];
	
	checkEmptiness = function(mistakes, pattern){
		mistakes.css("border","1px solid gray");
		pattern.css("border","1px solid gray");
		if(mistakes.val() === ""){
			mistakes.css("border","1px solid red");
			mistakes.after("<div class = 'warnning'>empty input</div>");
			return true;
		}
		if(pattern.val() === ""){
			pattern.css("border","1px solid red");
			pattern.after("<div class = 'warnning'>empty input</div>");
			return true;
		}
		mistakesVal = parseInt(mistakes.val());
		patternVal = pattern.val();
		if(checkPattern(patternVal)){
			pattern.css("border","1px solid red");
			pattern.after("<div class = 'warnning'>wrong input</div>");
			return true;	
		}
		patternValLength = 0; 
		var patternInArray = patternVal.split(/[\[\]]/);
		for(var i = 0; i < patternInArray.length; i++){
			var digit = parseInt(patternInArray[i]); 
			if(!isNaN(digit)){
				patternValLength += digit;
			}else{
				patternValLength += patternInArray[i].length;
			}
		}
		if(mistakesVal > patternValLength){
			mistakes.css("border","1px solid red");
			pattern.css("border","1px solid red");
			pattern.after("<div class = 'warnning'>too large number</div>");
			return true;
		}
		return false;
	}
	
	function checkPattern(pattern){
		var brackerIsOpen = false;
		for(var i = 0; i < pattern.length; i++){
			if(pattern[i] === "["){
				brackerIsOpen = true;
			}else if(pattern[i] === "]"){
				if(i===0){
					return true;
				}else if(numbers.indexOf(pattern[i-1]) === -1){
					return true;
				}
				brackerIsOpen = false;
			}
			else if(IUPACcharacters.indexOf(pattern[i]) !== -1 && brackerIsOpen === true){
				return true; 
			}else if(IUPACcharacters.indexOf(pattern[i]) === -1 && brackerIsOpen === false){
				return true
			}
		}
		
		var patternInArray = pattern.split(/[\[\]]/);
		for(var i = 0; i < patternInArray.length; i++){
			if(i%2 === 1){
				if(patternInArray[i] === ""){
					return true;
				}else if(patternInArray[i][0] === "0"){
					return true;
				}
			}
		}
		return false;
	}
	
	checkPairOrder = function(p1, p2){
		p1.css("border","1px solid gray");
		p2.css("border","1px solid gray");
		var pattern1 = p1.val();
		var pattern2 = p2.val();
		if(pattern1.length !== pattern2.length){
			showRedWarning()
			return true;
		}
		pattern1 = pattern1.split(/[\[\]]/);
		pattern2 = pattern2.split(/[\[\]]/);
		pattern1 = removeLastEmpty(pattern1);
		pattern2 = removeLastEmpty(pattern2);
		pattern1 = makeDetailedPattern(pattern1);
		pattern2 = makeDetailedPattern(pattern2);
		if(pattern1.length !== pattern2.length){
			showRedWarning()
			return true;
		}
		
		for(var i = 0; i < pattern1.length; i++){
			var j = pattern1.length - i - 1;
			if( (pattern1[i] === "*" && pattern2[j] !== "*") || 
				(pattern1[i] !== "*" && pattern2[j] === "*")  ){
					showRedWarning();
					return true;
				}
			else if(checkDigits(pattern1[i], pattern2[j])){
				showRedWarning();
				return true;
			}
		}

		return false;
		
		
		function showRedWarning(){
			p1.css("border","1px solid red");
			p1.after("<div class = 'warnning'>wrong order or length</div>");
			p2.css("border","1px solid red");
			p2.after("<div class = 'warnning'>wrong order or length</div>");
		}
		
		function checkDigits(pat1, pat2){
			var digit1 = parseInt(pat1); 
			if(!isNaN(digit1)){
				var digit2 = parseInt(pat2)
				if(digit1 !== digit2){
					return true;		
				}
			}
			return false;
		}
		
		function removeLastEmpty(array){
			if(array[array.length-1] === ""){
				return array.slice(0, array.length-1);
			}
			return array;
		}
		
		function makeDetailedPattern(p){
			result = [];
			for(var i = 0; i < p.length; i++){
				if(numbers.indexOf(p[i][0]) !== -1){
					result.push(p[i]);
				}else{
					for(var j = 0; j < p[i].length; j++){
						result.push(p[i][j]);
					}
				}
			}
			return result;
		}
	}
	
	checkAlphabet = function(alphabet){
		if(alphabet.val().length !== 4){
			alphabet.css("border","1px solid red");
			alphabet.after("<div class = 'warnning'>wrong length</div>");
			return true; 
		}else{
			alphabet.css("border","1px solid gray");
			return false; 
		}
	}
	
	checkInsertion = function(number, letter){
		number.css("border","1px solid gray");
		letter.css("border","1px solid gray");
		var digit = number.val();
		var character = letter.val();
		if( (digit === "0" || digit === "") && character !== "" ){
			number.css("border","1px solid red");
			letter.css("border","1px solid red");
			letter.after("<div class = 'warnning'>number cannot be 0</div>");
			return true;
		}
		return false;
	}
	
	fillImputs = function(){	
		$("#Smistakes, #Hmistakes1, #Hmistakes2, #Rmistakes1, #Rmistakes2, #mistakes1, #mistakes2").keypress(function(event){
			var keyCode = event.keyCode || event.which;
			var character = String.fromCharCode(keyCode);
			var digit = parseInt(String.fromCharCode(keyCode)); 
			if(isNaN(digit) && operations.indexOf(keyCode) === -1){
				event.preventDefault();
			}	
		});	
		
		$("#SinsertionNumber, #HinsertionNumber, #RinsertionNumber, #insertionNumber").keypress(function(event){
			var keyCode = event.keyCode || event.which;
			var character = String.fromCharCode(keyCode);
			var digit = parseInt(String.fromCharCode(keyCode)); 
			if(isNaN(digit) && operations.indexOf(keyCode) === -1){
				event.preventDefault();
			}	
		});	
		
		$("#Spattern, #Hpattern1, #Hpattern2, #Rpattern1, #Rpattern2, #pattern1, #pattern2").keypress(function(event){
			var keyCode = event.keyCode || event.which;
			var character = String.fromCharCode(keyCode);
			if(IUPACcharacters.indexOf(character) === -1 && numbers.indexOf(character) === -1 && brakers.indexOf(character) === -1 && operations.indexOf(keyCode) === -1){
				event.preventDefault();
			}
		});
		
		$("#SinsertionLetter, #HinsertionLetter, #RinsertionLetter, #insertionLetter, #alphabet, #Ralphabet").keypress(function(event){
			var keyCode = event.keyCode || event.which;
			var character = String.fromCharCode(keyCode); 	
			if(IUPACcharacters.indexOf(character) === -1 && operations.indexOf(keyCode) === -1){
				event.preventDefault();
			}
		});
	}
	fillImputs();
	
	// classes
	//===============================================================================
	colors = new Colors();
	rnaStructure = new RNAStructure();
	showDescriptor = new ShowSaveDescriptor();
	var sizes = new Sizes();
	var readFiles = new ReadFile();
	var addSequence = new AddSequence();
	var changeSequence = new ChangeSequence();
	var undoRendo = new UndoRendo();
});